/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.internal;

import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.processing.recipe.ProcessingRecipeBuilder;
import com.simibubi.create.content.processing.recipe.StandardProcessingRecipe;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.providers.RegistrateRecipeProvider;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.neoforged.neoforge.common.Tags;
import plus.dragons.createdragonsplus.common.CDPCommon;
import plus.dragons.createdragonsplus.common.kinetics.fan.ending.EndingRecipe;
import plus.dragons.createdragonsplus.common.kinetics.fan.freezing.FreezingRecipe;
import plus.dragons.createdragonsplus.common.registry.CDPBlocks;
import plus.dragons.createdragonsplus.common.registry.CDPItems;
import plus.dragons.createdragonsplus.config.CDPConfig;
import plus.dragons.createdragonsplus.data.recipe.ShapedRecipeBuilder;
import plus.dragons.createdragonsplus.data.recipe.ShapelessRecipeBuilder;
import plus.dragons.createdragonsplus.data.recipe.VanillaRecipeBuilders;

public class CDPRecipeProvider
extends RegistrateRecipeProvider {
    public CDPRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super((AbstractRegistrate)CDPCommon.REGISTRATE, output, registries);
    }

    protected void buildRecipes(RecipeOutput output) {
        this.buildMachineRecipes(output);
        this.buildMaterialRecipes(output);
        this.buildFreezingRecipes(output);
        this.buildEndingRecipes(output);
    }

    private void buildMachineRecipes(RecipeOutput output) {
        ((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)((ShapelessRecipeBuilder)VanillaRecipeBuilders.shapeless().output((ItemLike)CDPBlocks.FLUID_HATCH)).require((TagKey<Item>)Tags.Items.INGOTS_COPPER)).require((ItemLike)AllBlocks.ITEM_DRAIN)).unlockedBy("has_item_drain", CDPRecipeProvider.has((ItemLike)AllBlocks.ITEM_DRAIN)).withCondition(CDPConfig.features().fluidHatch)).accept(output);
    }

    private void buildMaterialRecipes(RecipeOutput output) {
        ((ShapedRecipeBuilder)VanillaRecipeBuilders.shaped().output((ItemLike)CDPItems.BLAZE_UPGRADE_SMITHING_TEMPLATE, 2).define(Character.valueOf('t'), (ItemLike)CDPItems.BLAZE_UPGRADE_SMITHING_TEMPLATE).define(Character.valueOf('n'), (ItemLike)Items.NETHERRACK).define(Character.valueOf('b'), (ItemLike)Items.BLAZE_ROD).pattern("btb").pattern("bnb").pattern("bbb").unlockedBy("has_template", CDPRecipeProvider.has(CDPItems.BLAZE_UPGRADE_SMITHING_TEMPLATE)).withCondition(CDPConfig.features().blazeUpgradeSmithingTemplate)).accept(output);
    }

    private void buildFreezingRecipes(RecipeOutput output) {
        Function<ResourceLocation, StandardProcessingRecipe.Builder> freezing = FreezingRecipe::builder;
        this.conversion(freezing, (ItemLike)Items.ICE, (ItemLike)Items.PACKED_ICE).build(output);
        this.conversion(freezing, (ItemLike)Items.PACKED_ICE, (ItemLike)Items.BLUE_ICE).build(output);
        this.conversion(freezing, (ItemLike)Items.MAGMA_CREAM, (ItemLike)Items.SLIME_BALL).build(output);
        this.conversion(freezing, (ItemLike)Items.BLAZE_ROD, (ItemLike)Items.BREEZE_ROD).build(output);
    }

    private void buildEndingRecipes(RecipeOutput output) {
        Function<ResourceLocation, StandardProcessingRecipe.Builder> ending = EndingRecipe::builder;
        this.conversion(ending, (ItemLike)Items.COBBLESTONE, (ItemLike)Items.END_STONE).build(output);
        this.conversion(ending, (ItemLike)Items.STONE_BRICKS, (ItemLike)Items.END_STONE_BRICKS).build(output);
        this.conversion(ending, (ItemLike)Items.STONE_BRICK_WALL, (ItemLike)Items.END_STONE_BRICK_WALL).build(output);
        this.conversion(ending, (ItemLike)Items.STONE_BRICK_STAIRS, (ItemLike)Items.END_STONE_BRICK_STAIRS).build(output);
        this.conversion(ending, (ItemLike)Items.STONE_BRICK_SLAB, (ItemLike)Items.END_STONE_BRICK_SLAB).build(output);
        this.conversion(ending, (ItemLike)Items.APPLE, (ItemLike)Items.CHORUS_FRUIT).build(output);
        this.conversion(ending, (TagKey<Item>)Tags.Items.LEATHERS, (ItemLike)Items.PHANTOM_MEMBRANE).build(output);
    }

    private <B extends ProcessingRecipeBuilder<?, ?, B>> B conversion(Function<ResourceLocation, B> factory, ItemLike input, ItemLike output) {
        ResourceLocation recipeId = CDPCommon.REGISTRATE.asResource("%s_from_%s".formatted(this.safeName(output), this.safeName(input)));
        return (B)((ProcessingRecipeBuilder)factory.apply(recipeId)).require(input).output(output);
    }

    private <B extends ProcessingRecipeBuilder<?, ?, B>> B conversion(Function<ResourceLocation, B> factory, TagKey<Item> input, ItemLike output) {
        ResourceLocation recipeId = CDPCommon.REGISTRATE.asResource("%s_from_%s".formatted(this.safeName(output), this.safeName(input.location())));
        return (B)((ProcessingRecipeBuilder)factory.apply(recipeId)).require(input).output(output);
    }
}

